//
//  BIDocument+QueryHandler.h
//  BIViews
//
//  Created by Eric Hochmeister on 06/01/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "BIDocument.h"

@class BIUser, BIClient;
@class BIExtraFieldNames;
@class BITimeSlipType;

@interface BIDocument (QueryHandler)

- (BIClient*)clientWithABUID:(NSString*)abUID;
- (BIClient*)clientForABPerson:(ABPerson*)aPerson;

- (NSArray*)clients;
- (NSArray*)clientsIncludingMe;
- (NSArray*)projects;
- (NSArray*)projectsForClient:(BIClient*)aClient;

- (NSArray*)projectStages;
- (NSArray*)projectStates;
- (NSArray*)timeSlipTypes;

- (NSArray*)activeTimedTimeSlips;
- (NSArray*)activeProjects;

- (NSArray*)notLinkedTimedSlips;

- (NSArray*)projectsWithActiveForTimingSlips;

- (NSArray*)activeTimerSlips;

- (NSArray*)categories;

- (NSArray*)clientCategories;

- (NSArray*)paymentMethodTypes;
- (NSArray*)retainerPaymentMethodTypes;

- (NSArray*)slipTemplates;

- (BIExtraFieldNames*)projectExtraFieldNames;
- (BIExtraFieldNames*)clientExtraFieldNames;

- (BITimeSlipType*)timedSlipType;

- (NSArray*)activeTaxes;
- (NSArray*)activeConsolidatedTaxes;
- (NSArray*)activeNotAtomicConsolidatedTaxes;

- (NSArray*)taxesAppliedInDateRangeStart:(NSCalendarDate*)startDate
                                     end:(NSCalendarDate*)endDate;


@end
